#!/bin/bash
arg="$1"

if [ "$arg" = "gwn7000" -o "$arg" = "gwn7062" ]; then
    FLAGS="-DGWN_ROUTER"
    if [ "$arg" = "gwn7000" ]; then
        FLAGS="$FLAGS -DGWN7000"
    fi
elif [ "$arg" = "gwn7630" -o "$arg" = "gwn7615" -o "$arg" = "gwn7605" -o "$arg" = "gwn7602" -o "$arg" = "gwn7610" -o "$arg" = "gwn7600" -o "$arg" = "gwn7620" -o\
    "$arg" = "gwn7002w" -o "$arg" = "gwn7660" -o "$arg" = "gwn7664" -o "$arg" = "gwn7624" -o "$arg" = "gwn7625" -o "$arg" = "gwn7700" -o "$arg" = "gwn7703" -o\
    "$arg" = "gwn7300" -o "$arg" = "gwn7303" -o "$arg" = "gwn7302" -o "$arg" == "gwn730x" ]; then
    FLAGS="-DGWN_AP"
fi

#compile tinysvcmdns 
cd ../tinysvcmdns/
./build.sh $arg
cd -
. ../../../../public/build_funcs.sh


make clean
make CROSS=${CROSS_PREFIX} CFLAGS="$FLAGS" SLIBS=../tinysvcmdns/lib/${PRODUCT_TYPE}/${DEV}
if [ "$?" != 0 ]; then
    exit
fi

INSTALL_DIR=pkg_install
[ -d ${INSTALL_DIR} ] && rm -r ${INSTALL_DIR}/
mkdir -p ${INSTALL_DIR}

make install DESTDIR="${PWD}/${INSTALL_DIR}"

ccd gsmdns ${IMAGE_BUILD}packages/files/gsmdns/${PRODUCT_TYPE}/${DEV}/sbin

mkdir -p ${INSTALL_DIR}/etc/rc.d
mkdir -p ${INSTALL_DIR}/etc/init.d
cp gsmdns.init ${INSTALL_DIR}/etc/init.d/gsmdns
ln -s ../init.d/gsmdns ${INSTALL_DIR}/etc/rc.d/S99gsmdns
ccd ${INSTALL_DIR}/etc/init.d/gsmdns ${IMAGE_BUILD}packages/files/gsmdns/${PRODUCT_TYPE}/${DEV}/etc/init.d/
ccd ${INSTALL_DIR}/etc/rc.d/S99gsmdns ${IMAGE_BUILD}packages/files/gsmdns/${PRODUCT_TYPE}/${DEV}/etc/rc.d/
