/****************************************************************************
*
* FILENAME:        $RCSfile: gsmdns,v $
*
* LAST REVISION:   $Revision:  $
* LAST MODIFIED:   $Date:  $
*
* DESCRIPTION:     
*       Advertises gwn_{mac}.local for DNS-less discovery for web-interface 
*   access on port 80.
*   
*       Advertises Controller information for use for the GWN PC Discovery 
*    tool.
*
***************************************************************************/

#include <sys/socket.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <netinet/in.h>
#include <net/if.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <ifaddrs.h>

#include <syslog.h>

#include <mdns.h>
#include <mdnsd.h>
#include "util.h"
#include "gsmdns.h"

int main (int argc, char *argv[] ) {
    char ipv4_address[16];
    char ipv6_address[INET6_ADDRSTRLEN];
    char device_mac[13];
    char pretty_mac[18];
    char product [GWN_PRODUCT_LEN + 1] ;
    char hostname[ HOST_STRING_LEN + 1 ];
    static host_addr host[ADDR_IPV_MAX];
    char web_instance_string[80];
    char txt_product[30];
    char txt_mac[30];
    char txt_role[30];
    char txt_version[30];
    char version[12];
    const char *web_txt[] = {
		"path=/", 
		NULL
	};
    const char *controller_txt[] = {
		txt_role,
        txt_product,
        txt_mac,
        txt_version,
		NULL
	};
    //int has_ip_v4, has_ip_v6;

    openlog( "gsmdns", 0, LOG_DAEMON );

    util_wait_for_lan();

    util_get_interface_ip ( MANAGEMENT_IFNAME, ipv4_address );
    util_get_interface_ip_v6 ( MANAGEMENT_IFNAME, ipv6_address );

    syslog( LOG_INFO, "ipv4_address:%s  ipv6_address:%s\n", ipv4_address, ipv6_address );
    /* Get interface to bind to */
    inet_aton( ipv4_address, &host[ADDR_IPV4].sin_addr );
    inet_pton( AF_INET6, ipv6_address, &host[ADDR_IPV6].sin6_addr );

    util_get_mac ( device_mac );
    util_write_pretty_mac ( device_mac, pretty_mac );
    util_get_product ( product );
    snprintf ( hostname, sizeof( hostname ) , "gwn_%s.local", device_mac );
    snprintf( web_instance_string, sizeof( web_instance_string ), "Grandstream %s Web Management [%s]", product, pretty_mac ); 

    struct mdnsd *web_svr_v4 = mdnsd_start( host[ADDR_IPV4], ADDR_IPV4 );
    if (web_svr_v4 == NULL) {
        syslog( LOG_INFO, "Error starting ipv4 service" );
	}
    else {
        web_svr_v4->ipv4 = 1;
    }

    struct mdnsd *web_svr_v6 = mdnsd_start( host[ADDR_IPV6], ADDR_IPV6 );
    if (web_svr_v6 == NULL) {
        syslog( LOG_INFO, "Error starting ipv6 service" );
    }
    else {
        web_svr_v6->ipv6 = 1;
    }

    if( web_svr_v4 == NULL && web_svr_v6 == NULL ) {
        syslog( LOG_ERR, "Instance initialization failed" );
        return -1;
    }

    syslog( LOG_INFO, "Starting service" );
    //mdnsd_set_hostname(web_svr, hostname, inet_addr( ipv4_address ));
    if( web_svr_v4 ) {
        mdnsd_set_hostname(web_svr_v4, hostname, &host[ADDR_IPV4], ADDR_IPV4 );
    }
    if( web_svr_v6 ) {
        mdnsd_set_hostname(web_svr_v6, hostname, &host[ADDR_IPV6], ADDR_IPV6 );
    }
#if 0
    int has_ip_v6 = 1;
    if ( has_ip_v6 ) {
        struct rr_entry *aaaa_e = NULL;
        struct addrinfo hints;
        memset(&hints, 0, sizeof(hints));
        hints.ai_family = AF_INET6;
        hints.ai_flags = AI_NUMERICHOST;
        struct addrinfo* results;
        getaddrinfo(
            ipv6_address,
            NULL,
            &hints,
            &results);
        struct sockaddr_in6* addr = (struct sockaddr_in6*)results->ai_addr;
        struct in6_addr v6addr = addr->sin6_addr;
        freeaddrinfo(results);


        aaaa_e = rr_create_aaaa(create_nlabel(hostname), &v6addr);

        mdnsd_add_rr(web_svr_v6, aaaa_e);
    }
#endif

    if ( util_controller_role_is_master() )
        snprintf( txt_role, sizeof( txt_role ), "role=%s", "master" );
    else 
        snprintf( txt_role, sizeof( txt_role ), "role=%s", "slave" );

    snprintf( txt_product, sizeof( txt_product ), "product=%s", product);
    snprintf( txt_mac, sizeof( txt_mac ), "mac=%s", pretty_mac);

    util_get_firmware_version ( version );
    snprintf( txt_version, sizeof(txt_version), "version=%s", version );
   
    struct mdns_service *svc_v4;
    struct mdns_service * svc_v6;

    if( web_svr_v4 ) {
        svc_v4 = mdnsd_register_svc(web_svr_v4, web_instance_string,
                                        "_http._tcp.local", 80, NULL, web_txt);
        mdns_service_destroy(svc_v4);
        svc_v4 = mdnsd_register_svc(web_svr_v4, "Grandstream GWN Controller",
                                        GWN_CONTROLLER_TYPE, 14, NULL, controller_txt);
        mdns_service_destroy(svc_v4);
    }

    if( web_svr_v6 ) {
        svc_v6 = mdnsd_register_svc(web_svr_v6, web_instance_string,
                                        "_http._tcp.local", 80, NULL, web_txt);
        mdns_service_destroy(svc_v6);
        svc_v6 = mdnsd_register_svc(web_svr_v6, "Grandstream GWN Controller",
                                        GWN_CONTROLLER_TYPE, 14, NULL, controller_txt);
        mdns_service_destroy(svc_v6);
    }

    for (;;) 
        pause();
    mdnsd_stop(web_svr_v4);
    mdnsd_stop(web_svr_v6);
    syslog( LOG_INFO, "Shutting down service" );

    return 0;
}
