/****************************************************************************
*
* FILENAME:        $RCSfile: poe,v $
*
* LAST REVISION:   $Revision:  $
* LAST MODIFIED:   $Date:  $
*
* DESCRIPTION:     Controls USB and 5ghz power limits based on the power
*   source attached to the GWN7610.
*
* Copyright (c) 2016 by Grandstream Networks, Inc.
* All rights reserved.
*
* This material is proprietary to Grandstream Networks, Inc. and,
* in addition to the above mentioned Copyright, may be
* subject to protection under other intellectual property
* regimes, including patents, trade secrets, designs and/or
* trademarks.
*
* Any use of this material for any purpose, except with an
* express license from Grandstream Networks, Inc. is strictly
* prohibited.
*
***************************************************************************/
//===========================
// Includes
//===========================
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <stdint.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <sys/types.h>
#include <ifaddrs.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netdb.h>
#include <syslog.h>

#include "util.h"


#define GS_IN6_IS_INVALID_UCADDR(addr6) \
    ( IN6_IS_ADDR_UNSPECIFIED(addr6) || \
      IN6_IS_ADDR_LOOPBACK(addr6)    || \
      IN6_IS_ADDR_LINKLOCAL(addr6) )

#define GS_IN6_IS_MCADDR(addr6) \
    ( IN6_IS_ADDR_MULTICAST(addr6)    || \
      IN6_IS_ADDR_MC_NODELOCAL(addr6) || \
      IN6_IS_ADDR_MC_LINKLOCAL(addr6) || \
      IN6_IS_ADDR_MC_SITELOCAL(addr6) || \
      IN6_IS_ADDR_MC_ORGLOCAL(addr6)  || \
      IN6_IS_ADDR_MC_GLOBAL(addr6) )

#define GS_IN6_IS_VALID(addr6) ( !GS_IN6_IS_INVALID_UCADDR(addr6) && !GS_IN6_IS_MCADDR(addr6) )

//===========================
// Locals
//===========================
/* Variables */

/* Functions */

//=============================================================================
int 
util_get_interface_ip( 
    char *ifname, 
    char *addr_str 
)
//=============================================================================
{
    struct ifreq ifr;
    int fd;

    fd = socket( AF_INET, SOCK_DGRAM, 0 );
    if ( fd >= 0 )
    {
        strncpy( ifr.ifr_name, ifname, IFNAMSIZ - 1 );
        // Is the interface up?
        if ( ioctl( fd, SIOCGIFFLAGS, &ifr ) == 0 )
        {
            if ( !( ifr.ifr_flags & IFF_RUNNING ) )
            {
                close( fd );
                return -1;
            }
        }

        
        // Get interface IP
        if ( ioctl( fd, SIOCGIFADDR, &ifr ) == 0 )
        {
            strncpy( addr_str, inet_ntoa( ( ( struct sockaddr_in* ) &ifr.ifr_addr )->sin_addr ), 16 );
            close( fd );
            return 0;
        }
        close( fd );
    }

    return -1;
}
//=============================================================================
int 
util_get_interface_ip_v6 ( 
    char *ifname, 
    char *addr_str 
)
//=============================================================================
{
    struct ifaddrs *ifap, *ifa;
    //struct sockaddr_in6 *sa;
    char addr[INET6_ADDRSTRLEN];
    int ret_code = -1;
    struct in6_addr addr6;

    if ( getifaddrs (&ifap) != 0) {
        return ret_code;
    }

    for (ifa = ifap; ifa; ifa = ifa->ifa_next) {
        if ( strncmp( ifa->ifa_name, ifname, strlen( ifname )  ) == 0 ) {
            if (ifa->ifa_addr->sa_family==AF_INET6) {

                memset( &addr6, 0, sizeof( addr6 ) );
                memcpy( &addr6, &((struct sockaddr_in6 *)(ifa->ifa_addr))->sin6_addr, sizeof( addr6 ) );
                if ( !GS_IN6_IS_VALID(&addr6) ) {
                    continue;
                }
                //sa = (struct sockaddr_in6 *) ifa->ifa_addr;
                getnameinfo(ifa->ifa_addr, sizeof(struct sockaddr_in6), addr,
                          sizeof(addr), NULL, 0, NI_NUMERICHOST);
                strcpy( addr_str, addr );
                ret_code = 0;
            }
        }
    }

    freeifaddrs(ifap);
    return ret_code;
}


//=============================================================================
int 
util_get_mac (
    char * dev_mac
)
//=============================================================================
{
    FILE *procfs_data;
    char proc_mac[PROC_MAC_LEN + 1];
    // Read MAC
    
    procfs_data = fopen( "/proc/gxp/dev_info/dev_mac", "r" );
    fgets( proc_mac, PROC_MAC_LEN , procfs_data );
    fclose( procfs_data );
    // Format it
    util_reformat_mac_plain ( proc_mac );
    strcpy ( dev_mac, proc_mac );
    return 0;
}
//=============================================================================
int 
util_get_product (
    char * product
)
//=============================================================================
{
    FILE *procfs_data;
    
    procfs_data = fopen( "/proc/gxp/dev_info/dev_id", "r" );
    fgets( product, GWN_PRODUCT_LEN + 1 , procfs_data );
    fclose( procfs_data );

    return 0;
}

//=============================================================================
int 
util_get_firmware_version (
    char * version
)
//=============================================================================
{
    FILE *procfs_data;
    version[0] = '\0';
    procfs_data = fopen( "/tmp/gs_version", "r" );
    fgets( version, GWN_MAC_FIRMWARE_VERSION_LEN - 1 , procfs_data );
    fclose( procfs_data );
    // Strip off any potential newline chars.
    version[strcspn(version, "\r\n")] = 0;
    return 0;
}

//=============================================================================
void
util_reformat_mac_plain(
    char* mac
)
//=============================================================================
{
    char tmp_mac[13];
    tmp_mac[0] = mac[0];
    tmp_mac[1] = mac[1];
    tmp_mac[2] = mac[3];
    tmp_mac[3] = mac[4];
    tmp_mac[4] = mac[6];
    tmp_mac[5] = mac[7];
    tmp_mac[6] = mac[9];
    tmp_mac[7] = mac[10];
    tmp_mac[8] = mac[12];
    tmp_mac[9] = mac[13];
    tmp_mac[10] = mac[15];
    tmp_mac[11] = mac[16];
    tmp_mac[12] = '\0';

    memcpy( mac, tmp_mac, sizeof( tmp_mac ) );
    return;
}

//=============================================================================
void
util_write_pretty_mac(
    const char * mac,
    char* output
)
//=============================================================================
{
    snprintf( output, 18, "%c%c:%c%c:%c%c:%c%c:%c%c:%c%c",
             mac[0], mac[1],
             mac[2], mac[3],
             mac[4], mac[5],
             mac[6], mac[7],
             mac[8], mac[9],
             mac[10], mac[11] );
    return;
}
//=============================================================================
int 
util_controller_role_is_master ( 
    void 
)
//=============================================================================
{ 
    char role[10];
    FILE *f = popen("uci get controller.main.role", "r");
    fgets(role, sizeof(role), f);
    pclose(f);
    if ( strncmp ( role, "master", 6) == 0)
        return 1;
    else
        return 0;
}
//=============================================================================
void
util_wait_for_lan(
    void
)
//=============================================================================
{
    char address[32];
    char ipv6_address[INET6_ADDRSTRLEN];

    while  ( util_get_interface_ip( MANAGEMENT_IFNAME , address ) != 0 &&
        util_get_interface_ip_v6 ( MANAGEMENT_IFNAME, ipv6_address ) != 0 )  {
        syslog( LOG_INFO, "Waiting for LAN %s", MANAGEMENT_IFNAME );
        sleep(2);
    }
}