/****************************************************************************
*
* FILENAME:        $RCSfile: util.c $
*
* LAST REVISION:   $Revision: 1.2 $
* LAST MODIFIED:   $Date: 2014/03/18 15:46:57 $
*
* DESCRIPTION:     
*
* vi: set ts=4:
*
* Copyright (c) 2016 by Grandstream Networks, Inc.
* All rights reserved.
* 
* This material is proprietary to Grandstream Networks, Inc. and, 
* in addition to the above mentioned Copyright, may be 
* subject to protection under other intellectual property 
* regimes, including patents, trade secrets, designs and/or 
* trademarks. 
*
* Any use of this material for any purpose, except with an 
* express license from Grandstream Networks, Inc. is strictly 
* prohibited. 
*
***************************************************************************/
#ifndef __UTIL_H__
#define __UTIL_H__

//=================
//  Includes
//=================
#include "gsmdns.h"

//=================
// Defines
//=================
#define GWN_PRODUCT_LEN 15
#define GWN_MAC_FIRMWARE_VERSION_LEN 10
#define PROC_MAC_LEN 18
#define HOST_STRING_LEN 22
//=================
//  Globals
//=================

//=================
// Typedefs
//=================

//=================
// Functions
//=================
int util_get_interface_ip( char *ifname, char *addr_str );
int util_get_interface_ip_v6 ( char *ifname, char *addr_str );
void util_reformat_mac_plain( char* mac );
void util_write_pretty_mac( const char * mac, char* output );
int util_get_mac ( char * dev_mac );
int util_get_product( char * product );
int util_controller_role_is_master ( void );
void util_wait_for_lan( void );
int util_get_firmware_version ( char * version );

#endif
