#ifndef __PACKETSOURCE_QCA_H__
#define __PACKETSOURCE_QCA_H__

#include "config.h"

#if defined(HAVE_LIBPCAP) && defined(SYS_LINUX)

#include "packet.h"
#include "packet_ieee80211.h"
#include "packetsource.h"
#include "packetsource_pcap.h"

#ifdef HAVE_LOCALRADIOTAP
#include "local_ieee80211_radiotap.h"
#endif

#define USE_PACKETSOURCE_QCA

class PacketSource_Qca : public PacketSource_Pcap {
public:
	PacketSource_Qca() {
		fprintf(stderr, "FATAL OOPS: Packetsource_Qca()\n");
		exit(1);
	}

	PacketSource_Qca(GlobalRegistry *in_globalreg) :
		PacketSource_Pcap(in_globalreg) {

	}

	virtual KisPacketSource *CreateSource(GlobalRegistry *in_globalreg,
										  string in_interface,
										  vector<opt_pair> *in_opts) {
		return new PacketSource_Qca(in_globalreg, in_interface, in_opts);
	}

	virtual int AutotypeProbe(string in_device);
	virtual int RegisterSources(Packetsourcetracker *tracker);

	PacketSource_Qca(GlobalRegistry *in_globalreg, string in_interface,
						vector<opt_pair> *in_opts);

	virtual ~PacketSource_Qca() { }

	virtual int ParseOptions(vector<opt_pair> *in_opts);

	virtual int OpenSource();

	virtual int FetchChannelCapable() { return 1; }
    virtual int FetchHardwareChannel();

	virtual int EnableMonitor();
	virtual int DisableMonitor();
	virtual int SetChannel(unsigned int in_ch);

	virtual vector<unsigned int> FetchSupportedChannels(string in_interface);


protected:
	virtual void FetchRadioData(kis_packet *in_packet) { };

	void *control;
	bool ignore_primary_state;
    string vap;

	int orig_dlt;
	int opp_vap, force_vap;
	int stored_mode;
	int cherror_pending;
};

#endif /* osx and pcap */

#endif

