L.ui.view.extend({
	title: L.tr('Utilities'),

	runSeraph: L.rpc.declare({
		object: 'seraph',
		method: 'example',
		params: [ 'message', 'printgs' ],
		expect: { '': { code: -1 } }
	}),

	runTestServer: L.rpc.declare({
		object: 'test',
		method: 'hello',
		params: [ 'msg' ],
		expect: { '': { code: -1 } }
	}),

	runApList: L.rpc.declare({
		object: 'seraph',
		method: 'ap_list',
		expect: { '': { code: -1 } }
	}),

	runClientList: L.rpc.declare({
		object: 'seraph',
		method: 'client_list',
		expect: { '': { code: -1 } }
	}),

	execute: function() {
		var self = this;
		var tools = [ ];

		tools.push(['runApList', L.tr('AP List')]);
		tools.push(['runClientList', L.tr('Client List')]);
		$.when(
			self.runSeraph('?').then(function(rv) {
				if (rv.code != -1) tools.push(['runSeraph', L.tr('Seraph')]);
			}),
			self.runTestServer('?').then(function(rv) {
				if (rv.code != -1) tools.push(['runTestServer', L.tr('TestServer')]);
			})
		).then(function() {
			tools.sort(function(a, b) {
				if (a[0] < b[0])
					return -1;
				else if (a[0] > b[0])
					return 1;
				else
					return 0;
			});

			for (var i = 0; i < tools.length; i++)
				$('#tool').append($('<option />').attr('value', tools[i][0]).text(tools[i][1]));

			$('#run').click(function() {
				L.ui.loading(true);
				selected_tool = $('#tool').val();
				self[selected_tool]($('#host').val(), $('#printGS').is(':checked')).then(function(rv) {
					$('#output').empty().show();
					$('#formatted_output').empty().show();

					if (rv.stdout)
						$('#output').text(rv.stdout);

					if (rv.message)
						$('#output').text(rv.message);

					if (rv.result)
					{
						//$('#output').text(rv.result);
						for ( i = 0; i < rv.result.length; i++ )
						{
							if( selected_tool === "runApList" )
							{
								$('#output').append( "AP " + i + ": " + rv.result[i].ap_id + "<br />" );

								var data_table = new L.ui.table({
									caption: L.tr('formatted_output'),
									columns: [
										{
											caption: L.tr('Number'),
											key: 'index_display'
										},
										{
											caption: L.tr('AP ID'),
											key: 'ap_id'
										}
									]
								});
								data_table.rows( rv.result )
								data_table.insertInto('#formatted_output');
							}
							else if( selected_tool === "runClientList" )
							{
								$('#output').append( "AP " + ": " + rv.result[i].ap_id + " Client: " + rv.result[i].client_id + "<br />" );

								var data_table = new L.ui.table({
									caption: L.tr('formatted_output'),
									columns: [
										{
											caption: L.tr('AP ID'),
											key: 'ap_id'
										},
										{
											caption: L.tr('Client ID'),
											key: 'client_id'
										},
										{
											caption: L.tr('RX'),
											key: 'num_rx'
										},
										{
											caption: L.tr('TX'),
											key: 'num_tx'
										}
									]
								});
								data_table.rows( rv.result )
								data_table.insertInto('#formatted_output');
							}
						}
					}

					if (rv.stderr)
						$('#output').append($('<span />').css('color', 'red').text(rv.stderr));

					if (rv.rcv_time)
						$('#output').append("<br><br>Requested at: " + rv.rcv_time);

					L.ui.loading(false);
				});
			});
		});
	}
});
