#include <uci.h>

#include "utility.h"

//=============================================================================
const char *
uci_lookup_option_string_from_package_and_section (
    struct uci_context *uci_ctx,
    struct uci_package *p,
    const char *section_str,
    const char *option_name
)
//=============================================================================
{
    const char * option = NULL;
    struct uci_section *section = uci_lookup_section( uci_ctx, p, section_str );
    if ( section ) {
        option = uci_lookup_option_string( uci_ctx, section, option_name);
    }

    return option;
}
