#!/bin/bash

. ../../../../public/build_funcs.sh

make clean
make distclean
rm -rf build

./configure  \
        --crossbuild=Linux::${ARCH} \
        --prefix=/usr \
        --conf-path=/etc/nginx/nginx.conf \
        --error-log-path=/var/log/nginx/error.log \
        --pid-path=/var/run/nginx.pid \
        --lock-path=/var/lock/nginx.lock \
        --http-log-path=/var/log/nginx/access.log \
        --http-client-body-temp-path=/var/lib/nginx/body \
        --http-proxy-temp-path=/var/lib/nginx/proxy \
        --http-fastcgi-temp-path=/var/lib/nginx/fastcgi \
        --with-cc=${CROSS_PREFIX}gcc \
        --with-cc-opt="-I{TOOLCHAIN_INCLUDE_DIR}" \
        --with-ld-opt="-L${STAGING_DIR}/usr/lib/" \
        --with-openssl="${STAGING_DIR}/usr/lib/ -I{TOOLCHAIN_INCLUDE_DIR}/openssl" \
        --with-pcre \
        --with-zlib="${STAGING_DIR}/usr/lib/" \
        --with-stream \
        --with-stream_ssl_module \
        --with-stream_ssl_preread_module \
        --with-stream_realip_module \
        --with-http_ssl_module \
        --with-http_realip_module \
        --without-http_gzip_module \
        --without-http_charset_module \
        --without-http_userid_module \
        --without-http_access_module \
        --with-http_auth_basic_module \
        --with-http_autoindex_module \
        --without-http_geo_module \
        --without-http_split_clients_module \
        --without-http_referer_module \
        --without-http_uwsgi_module \
        --without-http_scgi_module \
        --without-http_memcached_module \
        --without-http_empty_gif_module \
        --without-http_upstream_hash_module \
        --without-http_upstream_ip_hash_module \
        --without-http_upstream_least_conn_module \
        --without-http_upstream_keepalive_module \
        --without-mail_pop3_module \
        --without-mail_imap_module \
        --without-mail_smtp_module  \
        --without-stream_limit_conn_module \
        --without-stream_access_module \
        --without-stream_upstream_hash_module \
        --without-stream_upstream_least_conn_module \
        --without-stream_upstream_zone_module \
        --add-module=./nginx-upload-module-2.3.0 \
        --add-module=./ngx-fancyindex-0.4.3

make CROSS=${CROSS_PREFIX}
if [ "$?" != 0 ]; then
    exit
fi

ccd objs/nginx ${IMAGE_BUILD}packages/files/nginx/${PRODUCT_TYPE}/${DEV}/usr/sbin/
