#!/bin/bash

. ../../../../public/build_funcs.sh

if [ "$1" == "gwn7610" ] ; then
    PARA="mips32"
elif [ "$1" == "gwn7000" ] ; then
    PARA="armv4"
elif [ "$1" == "gwn7002w" ] ; then
    PARA="armv4"
elif [ "$1" == "gwn7600" ] ; then
    PARA="armv4"
elif [ "$1" == "gwn7660" -o "$1" == "gwn7664" -o "$1" == "gwn7700" -o "$1" == "gwn7703" -o "$1" == "gwn7303" ]; then
    PARA="aarch64"
elif [ "$1" == "gwn7062" ] ; then
    PARA="aarch64"
elif [ "$1" == "gwn7630" ] || [ "$1" == "gwn7615" ] || [ "$1" == "gwn7605" ] || [ "$1" == "gwn7602" ] || [ "$1" == "gwn7052" ]; then
    PARA="mips32"
elif [ "$1" == "gwn730x" ] ; then
    PARA="aarch64"
elif [ "$1" == "gwn7302" ] || [ "$1" == "gwn7300" ]; then
    PARA="armv4"
fi

# Hint:
# If this fails to build on a clean checkout, manually run the ./Configure line,
# then run the build script again.

make clean

export cross=${CROSS_PREFIX}
./Configure --prefix=/usr --openssldir=/etc/ssl linux-$PARA shared no-err zlib-dynamic no-sse2 no-ssl2 no-md2 no-mdc2 no-rc5 no-sha0 no-camellia no-krb5 no-sha0
make depend CC="${cross}gcc" AR="${cross}ar r" RANLIB="${cross}ranlib"
make  CC="${cross}gcc" AR="${cross}ar r" RANLIB="${cross}ranlib"

if [ "$?" != "0" ]; then
    echo "Make Error"
    exit
fi

mkdir -p ${TOOLCHAIN_INCLUDE_DIR}/openssl/
cp -av -L ./include/openssl/*.h ${TOOLCHAIN_INCLUDE_DIR}/openssl/
ccd './libssl.so*' ${IMAGE_BUILD}packages/files/openssl/${PRODUCT_TYPE}/${DEV}/usr/lib/
ccd './libcrypto.so*' ${IMAGE_BUILD}packages/files/openssl/${PRODUCT_TYPE}/${DEV}/usr/lib/
$STRIP ./apps/openssl
ccd './apps/openssl' ${IMAGE_BUILD}packages/files/openssl/${PRODUCT_TYPE}/${DEV}/usr/bin/
ccd './libssl.so*' ${STAGING_DIR}/usr/lib/
ccd './libcrypto.so*' ${STAGING_DIR}/usr/lib/
